#ifndef __SLL_XSPI_MC_FLASH_INIT_H__
#define __SLL_XSPI_MC_FLASH_INIT_H__

#include "sll_ca_xspi_mc_t004_reg.h"


/*Define Version */
#define SLL_XSPI_MC_FLASH_INIT_VERSION  "22.2.1"   //  Year.Quarter.Minor


static const uint32_t sll_s26ks_data[4]      = {0x00200000, 0x01100412, 0x00002020, 0x8080A0A0};

static const uint32_t sll_s26hs_data[6]      = {0x00200000, 0x01100412, 0x00002020, 0x8080A0A0, 0x80277180, 0x00040A00}; 

static const uint32_t sll_s28hs_data[8]      = {0x1520C002, 0x01170812, 0x12121212, 0xEEEEEEEE, 0x80277180, 0x00064300, 0x00000A0A, 0x0000C0C0};
                                             
static const uint32_t sll_xspi_type1_data[6] = {0x1520C002, 0x01000712, 0x02020202, 0x0B0B0B0B, 0x80278100, 0x0000E700};                                       
//static const uint32_t sll_xspi_type2_data[6] = {0x1520C002, 0x01000C12, 0x82828282, 0xFDFDFDFD, 0x80278100, 0x0000E700};                                       
static const uint32_t sll_xspi_type2_data[6] = {0x1520C002, 0x01000C12, 0x02020202, 0x0C0C0C0C, 0x80278100, 0x0000E700};                                       

static const uint32_t sll_xspi_type2_04_data[6] = {0x1410C002, 0x01000C12, 0x33223322, 0xEEDDEEDD, 0x80278100, 0x0000EB00};                                       


static const uint32_t sll_mx25lm_data[7]     = {0x0524C000, 0x01000712, 0x12ED12ED, 0xEE11EE11, 0x802F7200, 0x00000002, 0x00000101};
static const uint32_t sll_mx25um_data[7]     = {0x0524C000, 0x01000712, 0x12ED12ED, 0xEE11EE11, 0x802F7200, 0x00000002, 0x00000303};
                                             
static const uint32_t sll_s27ks_01_data[4]   = {0x00200001, 0x0C0C0512, 0x00002020, 0x8080A0A0};

static const uint32_t sll_s27ks_02_data[4]   = {0x00200001, 0x0E0E0522, 0x00002020, 0x8080A0A0};

static const uint32_t sll_s27ks_03_data[4]   = {0x05240001, 0x10100522, 0xDEDEDEDE, 0xEEEEEEEE};

static const uint32_t sll_jsc_ssp8ag_data[5] = {0x01204001, 0x08100522, 0x00002020, 0x8080A0A0, 0xA05AA05A};

static const uint32_t sll_issi_wvo_data[5]   = {0x01204001, 0x10100522, 0x00002020, 0x8080A0A0, 0xA05AA05A};

static const uint32_t sll_aps_08l_ob_data[7] = {0x05208001, 0x070E0522, 0x8080A0A0, 0x00002020, 0x31003100, 0x20002000, 0x05000500};


/******************************************************************
*  Memory Types
*
******************************************************************/
#define MEM_NO_DEVICE       ((uint8_t) 0x00)

#define MEM_HYPERRAM_1_0    ((uint8_t) 0x10)
#define MEM_HYPERRAM_2_0    ((uint8_t) 0x11)

#define MEM_OCTARAM_2_0     ((uint8_t) 0x20)
#define MEM_OCTARAM_2_1     ((uint8_t) 0x21)

#define MEM_XCCELARAM_2_0   ((uint8_t) 0x30)

#define MEM_XSPIRAM_2_0     ((uint8_t) 0x40)

#define MEM_HYPERFLASH_1_0  ((uint8_t) 0x50)

#define MEM_SEMPERFLASH_1_0 ((uint8_t) 0x60)

#define MEM_SEMPERXSPI_1_0  ((uint8_t) 0x70)

#define MEM_XSPIFLASH_1_0   ((uint8_t) 0x80)
#define MEM_XSPIFLASH_1_1   ((uint8_t) 0x81)
#define MEM_XSPIFLASH_1_2   ((uint8_t) 0x82)

#define MEM_OCTAFLASH_1_0   ((uint8_t) 0x90)
#define MEM_OCTAFLASH_1_1   ((uint8_t) 0x91)


/******************************************************************
*  Macro: list of devices
*
* bit 31:24 -  memory type
* bit 23:16 -  memory size
* bit 15: 8 -  read latency
* bit  7: 1 -  extra features
* bit     0 -  boot mode (0:X8, 1:X1)
*
******************************************************************/
#define DEVICE_NAME_MEM_TYPE_IDX  24
#define DEVICE_NAME_MEM_SIZE_IDX  16
#define DEVICE_NAME_READ_TACC_IDX  8
#define DEVICE_NAME_BOOT_MODE_IDX  0


#define MEM_NONE         ((MEM_NO_DEVICE       << 24) | (0x00 << 16) | (0x00 << 8) | (0x00))
                                                                                
#define MEM_S26KS512S    ((MEM_HYPERFLASH_1_0  << 24) | (0x09 << 16) | (0x10 << 8) | (0x00))
                                                                                
#define MEM_S26HS512S_X1 ((MEM_SEMPERFLASH_1_0 << 24) | (0x09 << 16) | (0x10 << 8) | (0x01))
#define MEM_S26HS512S_X8 ((MEM_SEMPERFLASH_1_0 << 24) | (0x09 << 16) | (0x10 << 8) | (0x00))
                                                                                
#define MEM_S28HS512S_X1 ((MEM_SEMPERXSPI_1_0  << 24) | (0x09 << 16) | (0x17 << 8) | (0x01))
#define MEM_S28HS512S_X8 ((MEM_SEMPERXSPI_1_0  << 24) | (0x09 << 16) | (0x17 << 8) | (0x00))
                                                                                
#define MEM_MT35XU512_X1 ((MEM_XSPIFLASH_1_0   << 24) | (0x09 << 16) | (0x14 << 8) | (0x01))
#define MEM_MT35XU512_X8 ((MEM_XSPIFLASH_1_0   << 24) | (0x09 << 16) | (0x14 << 8) | (0x00))

#define MEM_GD55LX512_X1 ((MEM_XSPIFLASH_1_0   << 24) | (0x09 << 16) | (0x10 << 8) | (0x01))
#define MEM_GD55LX512_X8 ((MEM_XSPIFLASH_1_0   << 24) | (0x09 << 16) | (0x10 << 8) | (0x00))

#define MEM_EM064LX_X1   ((MEM_XSPIFLASH_1_1   << 24) | (0x06 << 16) | (0x10 << 8) | (0x01))
#define MEM_EM064LX_X8   ((MEM_XSPIFLASH_1_1   << 24) | (0x06 << 16) | (0x10 << 8) | (0x00))

#define MEM_EM064LX_X4   ((MEM_XSPIFLASH_1_2   << 24) | (0x06 << 16) | (0x10 << 8) | (0x01))


#define MEM_MX25UM512_X1 ((MEM_OCTAFLASH_1_0   << 24) | (0x09 << 16) | (0x13 << 8) | (0x01))
#define MEM_MX25UM512_X8 ((MEM_OCTAFLASH_1_0   << 24) | (0x09 << 16) | (0x13 << 8) | (0x00))

#define MEM_MX25LM512_X1 ((MEM_OCTAFLASH_1_1   << 24) | (0x09 << 16) | (0x0F << 8) | (0x01))
#define MEM_MX25LM512_X8 ((MEM_OCTAFLASH_1_1   << 24) | (0x09 << 16) | (0x0F << 8) | (0x00))

#define MEM_S27KS0641    ((MEM_HYPERRAM_1_0    << 24) | (0x06 << 16) | (0x0C << 8) | (0x00))
#define MEM_S27KS1281    ((MEM_HYPERRAM_1_0    << 24) | (0x07 << 16) | (0x0C << 8) | (0x00))

#define MEM_S27KS0642    ((MEM_HYPERRAM_2_0    << 24) | (0x06 << 16) | (0x0C << 8) | (0x00))
#define MEM_S27KS1282    ((MEM_HYPERRAM_2_0    << 24) | (0x07 << 16) | (0x0C << 8) | (0x00))

#define MEM_S27KS0643    ((MEM_XSPIRAM_2_0     << 24) | (0x06 << 16) | (0x0C << 8) | (0x00))
#define MEM_S27KS1283    ((MEM_XSPIRAM_2_0     << 24) | (0x07 << 16) | (0x0C << 8) | (0x00))
                         
#define MEM_JSC64SSP8AG  ((MEM_OCTARAM_2_0     << 24) | (0x06 << 16) | (0x10 << 8) | (0x00))
#define MEM_JSC28SSP8AG  ((MEM_OCTARAM_2_0     << 24) | (0x07 << 16) | (0x10 << 8) | (0x00))

#define MEM_IS66WVO16M8DALL ((MEM_OCTARAM_2_1  << 24) | (0x07 << 16) | (0x10 << 8) | (0x00))
#define MEM_IS66WVO32M8DALL ((MEM_OCTARAM_2_1  << 24) | (0x08 << 16) | (0x10 << 8) | (0x00))

                       
#define MEM_AP6408l_OB   ((MEM_XCCELARAM_2_0   << 24) | (0x06 << 16) | (0x0E << 8) | (0x00))
#define MEM_AP12808l_OB  ((MEM_XCCELARAM_2_0   << 24) | (0x07 << 16) | (0x0E << 8) | (0x00))
#define MEM_AP25608l_OB  ((MEM_XCCELARAM_2_0   << 24) | (0x08 << 16) | (0x0E << 8) | (0x00))
#define MEM_AP51208l_OB  ((MEM_XCCELARAM_2_0   << 24) | (0x09 << 16) | (0x0E << 8) | (0x00))


/******************************************************************
*  Function: xspi_mc_dev0_null_init
*
*  Purpose: Set Device 0 parameters for No memory
*
******************************************************************/
 void xspi_mc_dev0_null_init(uint32_t base_csr );

/******************************************************************
*  Function: xspi_mc_dev1_null_init
*
*  Purpose: Set Device 1 parameters for No memory
*
******************************************************************/
 void xspi_mc_dev1_null_init(uint32_t base_csr );

/******************************************************************
*  Function: xspi_mc_dev0_s26ks512s_init
*
*  Purpose: Set Device 1 parameters for s26ks512s memory
*
******************************************************************/
 void xspi_mc_dev0_s26ks_init(uint32_t base_csr, uint8_t size_log2 );

/******************************************************************
*  Function: xspi_mc_dev0_s26hs512s_init
*
*  Purpose: Set Device 1 parameters for s26hs512s memory
*
******************************************************************/
 void xspi_mc_dev0_s26hs_init(uint32_t base_csr, uint8_t size_log2, uint8_t boot_mode );
 

/******************************************************************
*  Function: xspi_mc_dev0_s28hs512s_init
*
*  Purpose: Set Device 1 parameters for s28hs512s memory
*
******************************************************************/
 void xspi_mc_dev0_s28hs_init(uint32_t base_csr, uint8_t size_log2, uint8_t boot_mode);


/******************************************************************
*  Function: xspi_mc_dev0_xspi_type1_init
*
*  Purpose: Set Device 1 parameters for mt35xu/gd55lx memory
*
******************************************************************/
 void xspi_mc_dev0_xspi_type1_init(uint32_t base_csr, uint8_t size_log2, uint8_t read_latency, uint8_t boot_mode);
 

/******************************************************************
*  Function: xspi_mc_dev0_xspi_type2_init
*
*  Purpose: Set Device 0 parameters for mt35xu/gd55lx memory
*
******************************************************************/
void xspi_mc_dev0_xspi_type2_init(uint32_t base_csr, uint8_t size_log2, uint8_t read_latency, uint8_t boot_mode);

/******************************************************************
*  Function: xspi_mc_dev0_xspi_type2_04_init
*
*  Purpose: Set Device 0 parameters for mt35xu/gd55lx memory
*
******************************************************************/
void xspi_mc_dev0_xspi_type2_04_init(uint32_t base_csr, uint8_t size_log2, uint8_t read_latency, uint8_t boot_mode);

/******************************************************************
*  Function: xspi_mc_dev0_mx25lm_init
*
*  Purpose: Set Device 1 parameters for macronix mx25lm memory
*
******************************************************************/
 void xspi_mc_dev0_mx25lm_init(uint32_t base_csr, uint8_t size_log2, uint8_t read_latency, uint8_t boot_mode);


/******************************************************************
*  Function: xspi_mc_dev0_mx25um_init
*
*  Purpose: Set Device 1 parameters for macronix mx25m memory
*
******************************************************************/
 void xspi_mc_dev0_mx25um_init(uint32_t base_csr, uint8_t size_log2, uint8_t read_latency, uint8_t boot_mode);


/******************************************************************
*  Function: xspi_mc_dev1_s27ks0641_init
*
*  Purpose: Set Device 1 parameters for s27ks0641 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_01_init(uint32_t base_csr, uint8_t size_log2 );

/******************************************************************
*  Function: xspi_mc_dev1_s27ks0642_init
*
*  Purpose: Set Device 1 parameters for s27ks0641 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_02_init(uint32_t base_csr, uint8_t size_log2 );
 

/******************************************************************
*  Function: xspi_mc_dev1_s27ks0643_init
*
*  Purpose: Set Device 1 parameters for s27ks0643 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_03_init(uint32_t base_csr,  uint8_t size_log2  );


/******************************************************************
*  Function: xspi_mc_dev1_jsc28ssp8ag_init
*
*  Purpose: Set Device 1 parameters for jsc28ssp8ag memory
*
******************************************************************/
 void xspi_mc_dev1_jsc_ssp8ag_init(uint32_t base_csr, uint8_t size_log2 );


/******************************************************************
*  Function: xspi_mc_dev1_issi_wvo_init
*
*  Purpose: Set Device 1 parameters for ISSI OctaRAM memory
*
******************************************************************/
 void xspi_mc_dev1_issi_wvo_init(uint32_t base_csr, uint8_t size_log2 );


/******************************************************************
*  Function: xspi_mc_dev1_ap6408l_ob_init
*
*  Purpose: Set Device 1 parameters for ap6408l_ob memory
*
******************************************************************/
 void xspi_mc_dev1_aps_08l_ob_init(uint32_t base_csr, uint8_t size_log2 );


/******************************************************************
*  Function: xspi_mc_cntrl_init
*
*  Purpose: Init Memory Controller 
*
******************************************************************/
uint32_t xspi_mc_cntrl_init     (xSPI_MBMC_Info *g_xSPI_MBMC_inst);
uint32_t xspi_mc_cntrl_dev0_init(uint32_t base_csr, uint32_t base_addr, uint32_t dev_name);
uint32_t xspi_mc_cntrl_dev1_init(uint32_t base_csr, uint32_t base_addr, uint32_t dev_name);


#endif //__SLL_XSPI_MC_FLASH_INIT_H__
